/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.validator;

import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.XWorkException;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.DomHelper;
import com.opensymphony.xwork2.validator.ValidatorConfig;
import com.opensymphony.xwork2.validator.ValidatorFactory;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ValidatorFileParser {
    static final String DEFAULT_MULTI_TEXTVALUE_SEPARATOR = " ";
    static final String MULTI_TEXTVALUE_SEPARATOR_CONFIG_KEY = "xwork.validatorfileparser.multi_textvalue_separator";
    static String multiTextvalueSeparator = " ";

    @Inject(value="xwork.validatorfileparser.multi_textvalue_separator", required=false)
    public static void setMultiTextvalueSeparator(String type) {
        multiTextvalueSeparator = type;
    }

    public static String getMultiTextvalueSeparator() {
        return multiTextvalueSeparator;
    }

    public static List parseActionValidatorConfigs(InputStream is, String resourceName) {
        ArrayList validatorCfgs = new ArrayList();
        Document doc = null;
        InputSource in = new InputSource(is);
        in.setSystemId(resourceName);
        HashMap<String, String> dtdMappings = new HashMap<String, String>();
        dtdMappings.put("-//OpenSymphony Group//XWork Validator 1.0//EN", "xwork-validator-1.0.dtd");
        dtdMappings.put("-//OpenSymphony Group//XWork Validator 1.0.2//EN", "xwork-validator-1.0.2.dtd");
        doc = DomHelper.parse(in, dtdMappings);
        if (doc != null) {
            NodeList fieldNodes = doc.getElementsByTagName("field");
            NodeList validatorNodes = doc.getElementsByTagName("validator");
            ValidatorFileParser.addValidatorConfigs(validatorNodes, new HashMap(), validatorCfgs);
            for (int i = 0; i < fieldNodes.getLength(); ++i) {
                Element fieldElement = (Element)fieldNodes.item(i);
                String fieldName = fieldElement.getAttribute("name");
                HashMap<String, String> extraParams = new HashMap<String, String>();
                extraParams.put("fieldName", fieldName);
                NodeList validatorNodes2 = fieldElement.getElementsByTagName("field-validator");
                ValidatorFileParser.addValidatorConfigs(validatorNodes2, extraParams, validatorCfgs);
            }
        }
        return validatorCfgs;
    }

    public static void parseValidatorDefinitions(InputStream is) {
        ValidatorFileParser.parseValidatorDefinitions(is, null);
    }

    public static void parseValidatorDefinitions(InputStream is, String resourceName) {
        ValidatorFileParser.parseValidatorDefinitions(is, resourceName, ObjectFactory.getObjectFactory());
    }

    private static void verifyObjectFactory(ObjectFactory objectFactory) {
        if (objectFactory == null) {
            throw new IllegalStateException("Cannot find the ObjectFactory.  Please initialize it by calling 'ObjectFactory.setObjectFactory()'.");
        }
    }

    public static void parseValidatorDefinitions(InputStream is, String resourceName, ObjectFactory objectFactory) {
        InputSource in = new InputSource(is);
        in.setSystemId(resourceName);
        HashMap<String, String> dtdMappings = new HashMap<String, String>();
        dtdMappings.put("-//OpenSymphony Group//XWork Validator Config 1.0//EN", "xwork-validator-config-1.0.dtd");
        Document doc = DomHelper.parse(in, dtdMappings);
        if (doc != null) {
            NodeList nodes = doc.getElementsByTagName("validator");
            ValidatorFileParser.verifyObjectFactory(objectFactory);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element validatorElement = (Element)nodes.item(i);
                String name = validatorElement.getAttribute("name");
                String className = validatorElement.getAttribute("class");
                try {
                    objectFactory.buildValidator(className, new HashMap(), null);
                    ValidatorFactory.registerValidator(name, className);
                    continue;
                }
                catch (Exception e) {
                    throw new XWorkException("Unable to load validator class " + className, e, validatorElement);
                }
            }
        }
    }

    public static String getTextValue(Element valueEle) {
        StringBuffer value = new StringBuffer();
        NodeList nl = valueEle.getChildNodes();
        boolean firstCDataFound = false;
        for (int i = 0; i < nl.getLength(); ++i) {
            String nodeValue;
            Node item = nl.item(i);
            if ((!(item instanceof CharacterData) || item instanceof Comment) && !(item instanceof EntityReference) || (nodeValue = item.getNodeValue()) == null) continue;
            if (firstCDataFound) {
                value.append(ValidatorFileParser.getMultiTextvalueSeparator());
            } else {
                firstCDataFound = true;
            }
            value.append(nodeValue.trim());
        }
        return value.toString().trim();
    }

    private static void addValidatorConfigs(NodeList validatorNodes, Map extraParams, List validatorCfgs) {
        for (int j = 0; j < validatorNodes.getLength(); ++j) {
            Node defaultMessageNode;
            Element validatorElement = (Element)validatorNodes.item(j);
            String validatorType = validatorElement.getAttribute("type");
            HashMap<String, String> params = new HashMap<String, String>(extraParams);
            NodeList paramNodes = validatorElement.getElementsByTagName("param");
            for (int k = 0; k < paramNodes.getLength(); ++k) {
                Element paramElement = (Element)paramNodes.item(k);
                String paramName = paramElement.getAttribute("name");
                params.put(paramName, ValidatorFileParser.getTextValue(paramElement));
            }
            ValidatorFactory.lookupRegisteredValidatorType(validatorType);
            ValidatorConfig vCfg = new ValidatorConfig(validatorType, params);
            vCfg.setLocation(DomHelper.getLocationObject(validatorElement));
            vCfg.setShortCircuit(Boolean.valueOf(validatorElement.getAttribute("short-circuit")));
            NodeList messageNodes = validatorElement.getElementsByTagName("message");
            Element messageElement = (Element)messageNodes.item(0);
            String key = messageElement.getAttribute("key");
            if (key != null && key.trim().length() > 0) {
                vCfg.setMessageKey(key);
            }
            String defaultMessage = (defaultMessageNode = messageElement.getFirstChild()) == null ? "" : defaultMessageNode.getNodeValue();
            vCfg.setDefaultMessage(defaultMessage);
            validatorCfgs.add(vCfg);
        }
    }
}

