/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.config;

import com.opensymphony.xwork2.Action;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.ConfigurationProvider;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.config.entities.PackageConfig;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import com.opensymphony.xwork2.config.entities.ResultTypeConfig;
import com.opensymphony.xwork2.inject.ContainerBuilder;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ClassLoaderUtil;
import com.opensymphony.xwork2.util.ResolverUtil;
import com.opensymphony.xwork2.util.TextUtils;
import com.opensymphony.xwork2.util.location.LocatableProperties;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.config.Namespace;
import org.apache.struts2.config.NullResult;
import org.apache.struts2.config.ParentPackage;
import org.apache.struts2.config.Result;
import org.apache.struts2.config.Results;

public class ClasspathConfigurationProvider
implements ConfigurationProvider {
    private static final String DEFAULT_PAGE_PREFIX = "struts.configuration.classpath.defaultPagePrefix";
    private String defaultPagePrefix = "";
    private static final String DEFAULT_PAGE_EXTENSION = "struts.configuration.classpath.defaultPageExtension";
    private String defaultPageExtension = ".jsp";
    private static final String DEFAULT_PARENT_PACKAGE = "struts.configuration.classpath.defaultParentPackage";
    private String defaultParentPackage = "struts-default";
    private static final String FORCE_LOWER_CASE = "struts.configuration.classpath.forceLowerCase";
    private boolean forceLowerCase = true;
    private static final String ACTION = "Action";
    private PageLocator pageLocator = new ClasspathPageLocator();
    private boolean initialized = false;
    private String[] packages;
    private Map<String, PackageConfig> loadedPackageConfigs = new HashMap<String, PackageConfig>();
    private static final Log LOG = LogFactory.getLog(ClasspathConfigurationProvider.class);
    private Configuration configuration;

    public ClasspathConfigurationProvider(String[] pkgs) {
        this.packages = pkgs;
    }

    @Inject(value="struts.configuration.classpath.defaultParentPackage", required=false)
    public void setDefaultParentPackage(String defaultParentPackage) {
        this.defaultParentPackage = defaultParentPackage;
    }

    @Inject(value="struts.configuration.classpath.defaultPageExtension", required=false)
    public void setDefaultPageExtension(String defaultPageExtension) {
        this.defaultPageExtension = defaultPageExtension;
    }

    @Inject(value="struts.configuration.classpath.defaultPagePrefix", required=false)
    public void setDefaultPagePrefix(String defaultPagePrefix) {
        this.defaultPagePrefix = defaultPagePrefix;
    }

    @Inject(value="struts.configuration.classpath.forceLowerCase", required=false)
    public void setForceLowerCase(String force) {
        this.forceLowerCase = "true".equals(force);
    }

    public void setPageLocator(PageLocator locator) {
        this.pageLocator = locator;
    }

    protected void loadPackages(String[] pkgs) {
        ResolverUtil resolver = new ResolverUtil();
        resolver.find(new ResolverUtil.Test(){

            public boolean matches(Class type) {
                return Action.class.isAssignableFrom(type) || type.getSimpleName().endsWith(ClasspathConfigurationProvider.ACTION);
            }
        }, pkgs);
        Set actionClasses = resolver.getClasses();
        for (Class obj : actionClasses) {
            Class cls = obj;
            if (Modifier.isAbstract(cls.getModifiers())) continue;
            this.processActionClass(cls, pkgs);
        }
        for (String key : this.loadedPackageConfigs.keySet()) {
            this.configuration.addPackageConfig(key, this.loadedPackageConfigs.get(key));
        }
    }

    protected void processActionClass(Class cls, String[] pkgs) {
        ParentPackage annotation;
        PackageConfig pkgConfig;
        String name = cls.getName();
        String actionPackage = cls.getPackage().getName();
        String actionNamespace = null;
        String actionName = null;
        for (String pkg : pkgs) {
            if (!name.startsWith(pkg)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("ClasspathConfigurationProvider: Processing class " + name));
            }
            name = name.substring(pkg.length() + 1);
            actionNamespace = "";
            actionName = name;
            int pos = name.lastIndexOf(46);
            if (pos <= -1) break;
            actionNamespace = "/" + name.substring(0, pos).replace('.', '/');
            actionName = name.substring(pos + 1);
            break;
        }
        if (!actionPackage.equals((pkgConfig = this.loadPackageConfig(actionNamespace, actionPackage, cls)).getName())) {
            actionPackage = pkgConfig.getName();
        }
        if ((annotation = cls.getAnnotation(ParentPackage.class)) != null) {
            String parent = annotation.value();
            PackageConfig parentPkg = this.configuration.getPackageConfig(parent);
            if (parentPkg == null) {
                throw new ConfigurationException("ClasspathConfigurationProvider: Unable to locate parent package " + parent, (Object)annotation);
            }
            pkgConfig.addParent(parentPkg);
            if (!TextUtils.stringSet((String)pkgConfig.getNamespace()) && TextUtils.stringSet((String)parentPkg.getNamespace())) {
                pkgConfig.setNamespace(parentPkg.getNamespace());
            }
        }
        if (actionName.endsWith(ACTION)) {
            actionName = actionName.substring(0, actionName.length() - ACTION.length());
        }
        if (this.forceLowerCase && actionName.length() > 1) {
            int lowerPos = actionName.lastIndexOf(47) + 1;
            StringBuilder sb = new StringBuilder();
            sb.append(actionName.substring(0, lowerPos));
            sb.append(Character.toLowerCase(actionName.charAt(lowerPos)));
            sb.append(actionName.substring(lowerPos + 1));
            actionName = sb.toString();
        }
        ActionConfig actionConfig = new ActionConfig();
        actionConfig.setClassName(cls.getName());
        actionConfig.setPackageName(actionPackage);
        actionConfig.setResults(new ResultMap(cls, actionName, pkgConfig));
        pkgConfig.addActionConfig(actionName, actionConfig);
    }

    protected PackageConfig loadPackageConfig(String actionNamespace, String actionPackage, Class actionClass) {
        PackageConfig pkgConfig;
        Namespace ns;
        PackageConfig parent = null;
        if (actionClass != null && (ns = actionClass.getAnnotation(Namespace.class)) != null) {
            parent = this.loadPackageConfig(actionNamespace, actionPackage, null);
            actionNamespace = ns.value();
            actionPackage = actionClass.getName();
        }
        if ((pkgConfig = this.loadedPackageConfigs.get(actionPackage)) == null) {
            pkgConfig = new PackageConfig();
            pkgConfig.setName(actionPackage);
            if (parent == null) {
                parent = this.configuration.getPackageConfig(this.defaultParentPackage);
            }
            if (parent == null) {
                throw new ConfigurationException("ClasspathConfigurationProvider: Unable to locate default parent package: " + this.defaultParentPackage);
            }
            pkgConfig.addParent(parent);
            pkgConfig.setNamespace(actionNamespace);
            this.loadedPackageConfigs.put(actionPackage, pkgConfig);
        }
        return pkgConfig;
    }

    public void destroy() {
    }

    public void init(Configuration config) {
        this.configuration = config;
    }

    public void loadPackages() throws ConfigurationException {
        this.loadedPackageConfigs.clear();
        this.loadPackages(this.packages);
        this.initialized = true;
    }

    public boolean needsReload() {
        return !this.initialized;
    }

    public void register(ContainerBuilder builder, LocatableProperties props) throws ConfigurationException {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ResultMap<K, V>
    extends HashMap<K, V> {
        private Class actionClass;
        private String actionName;
        private PackageConfig pkgConfig;

        public ResultMap(Class actionClass, String actionName, PackageConfig pkgConfig) {
            this.actionClass = actionClass;
            this.actionName = actionName;
            this.pkgConfig = pkgConfig;
            while (!actionClass.getName().equals(Object.class.getName())) {
                Result result;
                Results results = actionClass.getAnnotation(Results.class);
                if (results != null) {
                    for (int i = 0; i < results.value().length; ++i) {
                        Result result2 = results.value()[i];
                        ResultConfig config = this.createResultConfig(result2);
                        this.put(config.getName(), config);
                    }
                }
                if ((result = actionClass.getAnnotation(Result.class)) != null) {
                    ResultConfig config = this.createResultConfig(result);
                    this.put(config.getName(), config);
                }
                actionClass = actionClass.getSuperclass();
            }
        }

        protected ResultConfig createResultConfig(Result result) {
            Class cls = result.type();
            if (cls == NullResult.class) {
                cls = null;
            }
            return this.createResultConfig(result.name(), cls, result.value(), this.createParameterMap(result.params()));
        }

        protected Map<String, String> createParameterMap(String[] parms) {
            HashMap<String, String> map = new HashMap<String, String>();
            int subtract = parms.length % 2;
            if (subtract != 0) {
                LOG.warn((Object)"Odd number of result parameters key/values specified.  The final one will be ignored.");
            }
            for (int i = 0; i < parms.length - subtract; ++i) {
                String key = parms[i++];
                String value = parms[i];
                map.put(key, value);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Adding parmeter[" + key + ":" + value + "] to result."));
            }
            return map;
        }

        private ResultConfig createResultConfig(Object key, Class<? extends Object> resultClass, String location, Map<? extends Object, ? extends Object> configParams) {
            String defaultParam;
            if (resultClass == null) {
                String defaultResultType = this.pkgConfig.getFullDefaultResultType();
                ResultTypeConfig resultType = (ResultTypeConfig)this.pkgConfig.getAllResultTypeConfigs().get(defaultResultType);
                configParams = resultType.getParams();
                String className = resultType.getClazz();
                try {
                    resultClass = ClassLoaderUtil.loadClass((String)className, this.getClass());
                }
                catch (ClassNotFoundException ex) {
                    throw new ConfigurationException("ClasspathConfigurationProvider: Unable to locate result class " + className, (Object)this.actionClass);
                }
            }
            try {
                defaultParam = (String)resultClass.getField("DEFAULT_PARAM").get(null);
            }
            catch (Exception e) {
                defaultParam = "location";
            }
            HashMap<String, String> params = new HashMap<String, String>();
            if (configParams != null) {
                params.putAll(configParams);
            }
            params.put(defaultParam, location);
            return new ResultConfig((String)key, resultClass.getName(), params);
        }
    }

    public static class ClasspathPageLocator
    implements PageLocator {
        public URL locate(String path) {
            return ClassLoaderUtil.getResource((String)path, this.getClass());
        }
    }

    public static interface PageLocator {
        public URL locate(String var1);
    }
}

