/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher.multipart;

import com.opensymphony.xwork2.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.dispatcher.multipart.MultiPartRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JakartaMultiPartRequest
implements MultiPartRequest {
    static final Log log = LogFactory.getLog(MultiPartRequest.class);
    private Map<String, List<FileItem>> files = new HashMap<String, List<FileItem>>();
    private Map<String, List<String>> params = new HashMap<String, List<String>>();
    private List<String> errors = new ArrayList<String>();
    private long maxSize;

    @Inject(value="struts.multipart.maxSize")
    public void setMaxSize(String maxSize) {
        this.maxSize = Long.parseLong(maxSize);
    }

    @Override
    public void parse(HttpServletRequest servletRequest, String saveDir) throws IOException {
        DiskFileItemFactory fac = new DiskFileItemFactory();
        fac.setSizeThreshold(0);
        if (saveDir != null) {
            fac.setRepository(new File(saveDir));
        }
        try {
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)fac);
            upload.setSizeMax(this.maxSize);
            List items = upload.parseRequest(this.createRequestContext(servletRequest));
            for (Object item1 : items) {
                List<Object> values;
                FileItem item = (FileItem)item1;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found item " + item.getFieldName()));
                }
                if (item.isFormField()) {
                    log.debug((Object)"Item is a normal form field");
                    values = this.params.get(item.getFieldName()) != null ? this.params.get(item.getFieldName()) : new ArrayList();
                    String charset = servletRequest.getCharacterEncoding();
                    if (charset != null) {
                        values.add(item.getString(charset));
                    } else {
                        values.add(item.getString());
                    }
                    this.params.put(item.getFieldName(), values);
                    continue;
                }
                log.debug((Object)"Item is a file upload");
                if (item.getName() == null || item.getName().trim().length() < 1) {
                    log.debug((Object)("No file has been uploaded for the field: " + item.getFieldName()));
                    continue;
                }
                values = this.files.get(item.getFieldName()) != null ? this.files.get(item.getFieldName()) : new ArrayList();
                values.add(item);
                this.files.put(item.getFieldName(), values);
            }
        }
        catch (FileUploadException e) {
            log.error((Object)e);
            this.errors.add(e.getMessage());
        }
    }

    @Override
    public Enumeration<String> getFileParameterNames() {
        return Collections.enumeration(this.files.keySet());
    }

    @Override
    public String[] getContentType(String fieldName) {
        List<FileItem> items = this.files.get(fieldName);
        if (items == null) {
            return null;
        }
        ArrayList<String> contentTypes = new ArrayList<String>(items.size());
        for (int i = 0; i < items.size(); ++i) {
            FileItem fileItem = items.get(i);
            contentTypes.add(fileItem.getContentType());
        }
        return contentTypes.toArray(new String[contentTypes.size()]);
    }

    @Override
    public File[] getFile(String fieldName) {
        List<FileItem> items = this.files.get(fieldName);
        if (items == null) {
            return null;
        }
        ArrayList<File> fileList = new ArrayList<File>(items.size());
        for (int i = 0; i < items.size(); ++i) {
            DiskFileItem fileItem = (DiskFileItem)items.get(i);
            fileList.add(fileItem.getStoreLocation());
        }
        return fileList.toArray(new File[fileList.size()]);
    }

    @Override
    public String[] getFileNames(String fieldName) {
        List<FileItem> items = this.files.get(fieldName);
        if (items == null) {
            return null;
        }
        ArrayList<String> fileNames = new ArrayList<String>(items.size());
        for (int i = 0; i < items.size(); ++i) {
            DiskFileItem fileItem = (DiskFileItem)items.get(i);
            fileNames.add(this.getCanonicalName(fileItem.getName()));
        }
        return fileNames.toArray(new String[fileNames.size()]);
    }

    @Override
    public String[] getFilesystemName(String fieldName) {
        List<FileItem> items = this.files.get(fieldName);
        if (items == null) {
            return null;
        }
        ArrayList<String> fileNames = new ArrayList<String>(items.size());
        for (int i = 0; i < items.size(); ++i) {
            DiskFileItem fileItem = (DiskFileItem)items.get(i);
            fileNames.add(fileItem.getStoreLocation().getName());
        }
        return fileNames.toArray(new String[fileNames.size()]);
    }

    @Override
    public String getParameter(String name) {
        List<String> v = this.params.get(name);
        if (v != null && v.size() > 0) {
            return v.get(0);
        }
        return null;
    }

    @Override
    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.params.keySet());
    }

    @Override
    public String[] getParameterValues(String name) {
        List<String> v = this.params.get(name);
        if (v != null && v.size() > 0) {
            return v.toArray(new String[v.size()]);
        }
        return null;
    }

    @Override
    public List getErrors() {
        return this.errors;
    }

    private String getCanonicalName(String filename) {
        int forwardSlash = filename.lastIndexOf("/");
        int backwardSlash = filename.lastIndexOf("\\");
        if (forwardSlash != -1 && forwardSlash > backwardSlash) {
            filename = filename.substring(forwardSlash + 1, filename.length());
        } else if (backwardSlash != -1 && backwardSlash >= forwardSlash) {
            filename = filename.substring(backwardSlash + 1, filename.length());
        }
        return filename;
    }

    private RequestContext createRequestContext(final HttpServletRequest req) {
        return new RequestContext(){

            public String getCharacterEncoding() {
                return req.getCharacterEncoding();
            }

            public String getContentType() {
                return req.getContentType();
            }

            public int getContentLength() {
                return req.getContentLength();
            }

            public InputStream getInputStream() throws IOException {
                return req.getInputStream();
            }
        };
    }
}

