/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.portlet.result;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.util.TextUtils;
import java.io.IOException;
import java.util.Map;
import java.util.StringTokenizer;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.StrutsResultSupport;
import org.apache.struts2.portlet.PortletActionConstants;
import org.apache.struts2.portlet.context.PortletActionContext;

public class PortletResult
extends StrutsResultSupport
implements PortletActionConstants {
    private static final long serialVersionUID = 434251393926178567L;
    private static final Log LOG = LogFactory.getLog(PortletResult.class);
    private String contentType = "text/html";
    private String title;

    public PortletResult() {
    }

    public PortletResult(String location) {
        super(location);
    }

    public void doExecute(String finalLocation, ActionInvocation actionInvocation) throws Exception {
        if (PortletActionContext.isRender()) {
            this.executeRenderResult(finalLocation);
        } else if (PortletActionContext.isEvent()) {
            this.executeActionResult(finalLocation, actionInvocation);
        } else {
            this.executeRegularServletResult(finalLocation, actionInvocation);
        }
    }

    private void executeRegularServletResult(String finalLocation, ActionInvocation actionInvocation) throws ServletException, IOException {
        ServletContext ctx = ServletActionContext.getServletContext();
        HttpServletRequest req = ServletActionContext.getRequest();
        HttpServletResponse res = ServletActionContext.getResponse();
        try {
            ctx.getRequestDispatcher(finalLocation).include((ServletRequest)req, (ServletResponse)res);
        }
        catch (ServletException e) {
            LOG.error((Object)("ServletException including " + finalLocation), (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            LOG.error((Object)("IOException while including result '" + finalLocation + "'"), (Throwable)e);
            throw e;
        }
    }

    protected void executeActionResult(String finalLocation, ActionInvocation invocation) {
        LOG.debug((Object)"Executing result in Event phase");
        ActionResponse res = PortletActionContext.getActionResponse();
        Map sessionMap = invocation.getInvocationContext().getSession();
        LOG.debug((Object)("Setting event render parameter: " + finalLocation));
        if (finalLocation.indexOf(63) != -1) {
            PortletResult.convertQueryParamsToRenderParams(res, finalLocation.substring(finalLocation.indexOf(63) + 1));
            finalLocation = finalLocation.substring(0, finalLocation.indexOf(63));
        }
        if (finalLocation.endsWith(".action")) {
            finalLocation = finalLocation.substring(0, finalLocation.lastIndexOf("."));
            res.setRenderParameter("struts.portlet.action", finalLocation);
        } else {
            res.setRenderParameter("struts.portlet.action", "renderDirect");
            sessionMap.put("struts.portlet.renderDirectLocation", finalLocation);
        }
        res.setRenderParameter("struts.portlet.mode", PortletActionContext.getRequest().getPortletMode().toString());
    }

    protected static void convertQueryParamsToRenderParams(ActionResponse response, String queryParams) {
        StringTokenizer tok = new StringTokenizer(queryParams, "&");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            String key = token.substring(0, token.indexOf(61));
            String value = token.substring(token.indexOf(61) + 1);
            response.setRenderParameter(key, value);
        }
    }

    protected void executeRenderResult(final String finalLocation) throws PortletException, IOException {
        LOG.debug((Object)"Executing result in Render phase");
        PortletConfig cfg = PortletActionContext.getPortletConfig();
        RenderRequest req = PortletActionContext.getRenderRequest();
        RenderResponse res = PortletActionContext.getRenderResponse();
        LOG.debug((Object)("PortletConfig: " + cfg));
        LOG.debug((Object)("RenderRequest: " + req));
        LOG.debug((Object)("RenderResponse: " + res));
        res.setContentType(this.contentType);
        if (TextUtils.stringSet((String)this.title)) {
            res.setTitle(this.title);
        }
        LOG.debug((Object)("Location: " + finalLocation));
        PortletRequestDispatcher dispatcher = cfg.getPortletContext().getRequestDispatcher(finalLocation);
        if (dispatcher == null) {
            throw new PortletException("Could not locate dispatcher for '" + finalLocation + "'");
        }
        new IncludeTemplate(){

            protected void when(PortletException e) {
                LOG.error((Object)("PortletException while dispatching to '" + finalLocation + "'"));
            }

            protected void when(IOException e) {
                LOG.error((Object)("IOException while dispatching to '" + finalLocation + "'"));
            }
        }.include(dispatcher, req, res);
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    static class IncludeTemplate {
        IncludeTemplate() {
        }

        protected void include(PortletRequestDispatcher dispatcher, RenderRequest req, RenderResponse res) throws PortletException, IOException {
            try {
                dispatcher.include(req, res);
            }
            catch (PortletException e) {
                this.when(e);
                throw e;
            }
            catch (IOException e) {
                this.when(e);
                throw e;
            }
        }

        protected void when(PortletException e) {
        }

        protected void when(IOException e) {
        }
    }
}

