/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.xslt;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.Result;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.TextParseUtil;
import com.opensymphony.xwork2.util.ValueStack;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.views.xslt.AdapterFactory;
import org.apache.struts2.views.xslt.ServletURIResolver;

public class XSLTResult
implements Result {
    private static final long serialVersionUID = 6424691441777176763L;
    private static final Log LOG = LogFactory.getLog(XSLTResult.class);
    public static final String DEFAULT_PARAM = "stylesheetLocation";
    private static final Map<String, Templates> templatesCache = new HashMap<String, Templates>();
    protected boolean noCache;
    private String stylesheetLocation;
    private String matchingPattern;
    private String excludingPattern;
    private String exposedValue;
    private boolean parse;
    private AdapterFactory adapterFactory;

    public XSLTResult() {
    }

    public XSLTResult(String stylesheetLocation) {
        this();
        this.setStylesheetLocation(stylesheetLocation);
    }

    @Inject(value="struts.xslt.nocache")
    public void setNoCache(String val) {
        this.noCache = "true".equals(val);
    }

    public void setLocation(String location) {
        this.setStylesheetLocation(location);
    }

    public void setStylesheetLocation(String location) {
        if (location == null) {
            throw new IllegalArgumentException("Null location");
        }
        this.stylesheetLocation = location;
    }

    public String getStylesheetLocation() {
        return this.stylesheetLocation;
    }

    public String getExposedValue() {
        return this.exposedValue;
    }

    public void setExposedValue(String exposedValue) {
        this.exposedValue = exposedValue;
    }

    public String getMatchingPattern() {
        return this.matchingPattern;
    }

    public void setMatchingPattern(String matchingPattern) {
        this.matchingPattern = matchingPattern;
    }

    public String getExcludingPattern() {
        return this.excludingPattern;
    }

    public void setExcludingPattern(String excludingPattern) {
        this.excludingPattern = excludingPattern;
    }

    public void setParse(boolean parse) {
        this.parse = parse;
    }

    public void execute(ActionInvocation invocation) throws Exception {
        long startTime = System.currentTimeMillis();
        String location = this.getStylesheetLocation();
        if (this.parse) {
            ValueStack stack = ActionContext.getContext().getValueStack();
            location = TextParseUtil.translateVariables((String)location, (ValueStack)stack);
        }
        try {
            Transformer transformer;
            HttpServletResponse response = ServletActionContext.getResponse();
            Templates templates = null;
            if (location != null) {
                templates = this.getTemplates(location);
                transformer = templates.newTransformer();
            } else {
                transformer = TransformerFactory.newInstance().newTransformer();
            }
            transformer.setURIResolver(this.getURIResolver());
            String mimeType = templates == null ? "text/xml" : templates.getOutputProperties().getProperty("media-type");
            if (mimeType == null) {
                mimeType = "text/html";
            }
            response.setContentType(mimeType);
            Object result = invocation.getAction();
            if (this.exposedValue != null) {
                ValueStack stack = invocation.getStack();
                result = stack.findValue(this.exposedValue);
            }
            Source xmlSource = this.getDOMSourceForStack(result);
            PrintWriter out = response.getWriter();
            LOG.debug((Object)("xmlSource = " + xmlSource));
            transformer.transform(xmlSource, new StreamResult(out));
            out.flush();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Time:" + (System.currentTimeMillis() - startTime) + "ms"));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to render XSLT Template, '" + location + "'"), (Throwable)e);
            throw e;
        }
    }

    protected AdapterFactory getAdapterFactory() {
        if (this.adapterFactory == null) {
            this.adapterFactory = new AdapterFactory();
        }
        return this.adapterFactory;
    }

    protected void setAdapterFactory(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    protected URIResolver getURIResolver() {
        return new ServletURIResolver(ServletActionContext.getServletContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Templates getTemplates(String path) throws TransformerException, IOException {
        String pathFromRequest = ServletActionContext.getRequest().getParameter("xslt.location");
        if (pathFromRequest != null) {
            path = pathFromRequest;
        }
        if (path == null) {
            throw new TransformerException("Stylesheet path is null");
        }
        Templates templates = templatesCache.get(path);
        if (this.noCache || templates == null) {
            Map<String, Templates> map = templatesCache;
            synchronized (map) {
                URL resource = ServletActionContext.getServletContext().getResource(path);
                if (resource == null) {
                    throw new TransformerException("Stylesheet " + path + " not found in resources.");
                }
                LOG.debug((Object)("Preparing XSLT stylesheet templates: " + path));
                TransformerFactory factory = TransformerFactory.newInstance();
                templates = factory.newTemplates(new StreamSource(resource.openStream()));
                templatesCache.put(path, templates);
            }
        }
        return templates;
    }

    protected Source getDOMSourceForStack(Object value) throws IllegalAccessException, InstantiationException {
        return new DOMSource(this.getAdapterFactory().adaptDocument("result", value));
    }
}

