/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package be.hogent.iii.voetbal.webservice.adapter;

import be.hogent.iii.voetbal.datalaag.interfaces.IClub;
import be.hogent.iii.voetbal.datalaag.interfaces.IDataStorage;
import be.hogent.iii.voetbal.datalaag.interfaces.IPersoon;
import be.hogent.iii.voetbal.datalaag.interfaces.IStadion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 *
 * @author vongenae
 */
public class VoetbalData {
    IDataStorage data;
    public VoetbalData(IDataStorage data) {
        this.data = data;
    }
    
    public Club[] getClubs() {
        List<Club> lijstClubs = new ArrayList<Club>();
        try {
            Collection<IClub> verzClubs = data.getClubs();
            for (IClub club : verzClubs) {
                lijstClubs.add(convertIClub(club));
            }
        } catch (Exception e) {
            lijstClubs.clear();
            e.printStackTrace();
        }
        
        return lijstClubs.toArray(new Club[0]);
    }
    
    private Club convertIClub(IClub club) {
        Club dataClub = new Club();
        dataClub.setId(club.getId());
        dataClub.setNaam(club.getNaam());
        dataClub.setLogo(club.getLogo());
        dataClub.setClubkleuren(club.getClubkleuren());
        dataClub.setWebsite(club.getWebsite());
        dataClub.setStadion(convertIStadion(club.getStadion()));
        dataClub.setSpelers(convertListIPersoon(club.getSpelers()));        
        return dataClub;
    }
    
    private Stadion convertIStadion(IStadion stadion) {
        Stadion dataStadion = new Stadion();
        dataStadion.setNaam(stadion.getNaam());
        dataStadion.setStraat(stadion.getStraat());
        dataStadion.setNummer(stadion.getNummer());
        dataStadion.setPostCode(stadion.getPostCode());
        dataStadion.setGemeenteNaam(stadion.getGemeenteNaam());
        dataStadion.setCapaciteit(stadion.getCapaciteit());
        return dataStadion;
    }
    
    private Persoon[] convertListIPersoon(List<IPersoon> spelers) {
        List<Persoon> spelersLijst = new ArrayList<Persoon>();
        for (IPersoon speler : spelers) {
            Persoon dataSpeler = new Persoon();
            dataSpeler.setId(speler.getId());
            dataSpeler.setNaam(speler.getNaam());
            dataSpeler.setFoto(speler.getFoto());
            dataSpeler.setNationaliteit(speler.getNationalteit());
            spelersLijst.add(dataSpeler);
        }
        return spelersLijst.toArray(new Persoon[0]);
    }
}
