#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <stdlib.h>
#include <errno.h>
#include <netinet/in.h> 
#include <arpa/inet.h> // inet_addr
#include <iostream>
using namespace std;

const int BANK_POORT = 2007; /* poort bankserver */

struct financ_stat {
    int gestort;
    int afgehaald;
    unsigned short aantal_stortingen;
    unsigned short aantal_afhalingen;
};

void ExitWithMessage(char *message){
  perror(message);
  exit(1);
}

sockaddr_in vuladresin(char *IP_adres, int poort) {
  /* vul server adres structure in */
  sockaddr_in servaddr;
  memset(&servaddr, 0, sizeof(servaddr));    /* maak struct leeg */
  servaddr.sin_family = AF_INET;             /* Internet adres */
  if (inet_aton(IP_adres,&servaddr.sin_addr) == 0)
      ExitWithMessage("Geen IP_adres");      /* server adres */
  servaddr.sin_port = htons(poort);          /* echo poort */
  return servaddr;
}

int main(int argc, char **argv){

  // poort en bericht inlezen
  int poort;
  char *gestort, *afgehaald;
  if (argc < 4 || argc > 5){
    cout << "Gebruik: " << argv[0] << " <IPaddress> [poort] <gestort> <afgehaald>" 
	<< endl;
    exit(1);
  } else if (argc == 5) {
    poort = atoi(argv[2]);
    gestort = argv[3];
    afgehaald = argv[4];
  } else {
    poort = BANK_POORT;
    gestort = argv[2];
    afgehaald = argv[3];
  }

  /* maak TCP socket */
  int sockfd = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP);
  if( sockfd < 0) {
    ExitWithMessage("socket");
  }

  /* vul server adres structure in */
  sockaddr_in servaddr = vuladresin(argv[1],poort);

  /* maak verbinding met server */
  if (connect(sockfd, (struct sockaddr *) &servaddr, sizeof(servaddr)) < 0) {
    ExitWithMessage("connect");
  }

  /* stuur struct naar de server */
  financ_stat bericht;
  bericht.gestort = htonl(atoi(gestort));
  bericht.aantal_stortingen = htons(10);
  bericht.afgehaald = htonl(atoi(afgehaald));
  bericht.aantal_afhalingen = htons(30);
	cout << sizeof(bericht) << endl;
  if(send(sockfd, &bericht, sizeof(bericht), 0) != sizeof(bericht))
    ExitWithMessage("send");

  close(sockfd); /* sluit de verbinding */
  return 0;
}


