#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <stdlib.h>
#include <errno.h>
#include <netinet/in.h> 
#include <arpa/inet.h> // inet_addr
#include <iostream>
using namespace std;

const int MAX_GROOTTE = 5;
const int POORT = 2007;

struct financ_stat {
    int gestort;
    unsigned short aantal_stortingen;
    int afgehaald;
    unsigned short aantal_afhalingen;
};

void ExitWithMessage(char *message){
  perror(message);
  exit(1);
}

sockaddr_in vuladresin(unsigned long server, int poort) {
  /* vul server adres structure in */
  sockaddr_in servaddr;
  memset(&servaddr, 0, sizeof(servaddr));        /* maak struct leeg */
  servaddr.sin_family = AF_INET;                 /* Internet adres */
  servaddr.sin_addr.s_addr = htonl(server); /* server adres */
  servaddr.sin_port = htons(poort);          /* echo poort */
  return servaddr;
}

int main(int argc, char **argv){

  /* Maak een TCP socket */
  int listenfd = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP);
  if( listenfd < 0)
    ExitWithMessage("socket");

  /* Vul server adres struct in */
  sockaddr_in servaddr = vuladresin(INADDR_ANY,POORT);
  
  /* Bind socket aan lokaal adres */
  if (bind(listenfd, (struct sockaddr *)&servaddr, sizeof(servaddr)) < 0)
    ExitWithMessage("bind");

  /* Maak de socket passief zodat hij luistert naar connectie-aanvragen */
  if(listen(listenfd, 10) < 0)
    ExitWithMessage("listen");

  /* oneindige lus */
  sockaddr_in cliaddr;
  char buff[MAX_GROOTTE];
  while(true) {
    unsigned int len = sizeof(cliaddr);
    int connfd = accept(listenfd, (sockaddr *) &cliaddr, &len);
    if(connfd < 0)
        perror("accept");
    else {
	/* er is een verbinding; handel client af */
	cout << "connectie met " << inet_ntoa(cliaddr.sin_addr) << endl;
        financ_stat bericht;
	int aantalOntvangen = recv(connfd,&bericht,sizeof(bericht), 0);
	if (aantalOntvangen < sizeof(bericht)){
	    cout << "Te weinig bytes" << endl;
	} else {
            cout << "Gestort: " << ntohl(bericht.gestort) 
		<< " (" << ntohs(bericht.aantal_stortingen) << ") afgehaald: " 
		<< ntohl(bericht.afgehaald) << " (" 
		<< ntohs(bericht.aantal_afhalingen) << ")" << endl;
        }
	
	/* sluit de verbindig */
	close(connfd);
    }
  }
  /* onbereikbaar */
}
