#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <stdlib.h>
#include <errno.h>
#include <netinet/in.h> 
#include <arpa/inet.h> // inet_addr
#include <iostream>
using namespace std;

const int PROTOCOL_POORT = 2007; /* poort protocolserver */

void ExitWithMessage(char *message){
  perror(message);
  exit(1);
}

sockaddr_in vuladresin(char *IP_adres, int poort) {
  /* vul server adres structure in */
  sockaddr_in servaddr;
  memset(&servaddr, 0, sizeof(servaddr));    /* maak struct leeg */
  servaddr.sin_family = AF_INET;             /* Internet adres */
  if (inet_aton(IP_adres,&servaddr.sin_addr) == 0)
      ExitWithMessage("Geen IP_adres");      /* server adres */
  servaddr.sin_port = htons(poort);          /* echo poort */
  return servaddr;
}

int main(int argc, char **argv){

  // poort en bericht inlezen
  int poort;
  char *bericht;
  if (argc < 3 || argc > 4){
    cout << "Gebruik: " << argv[0] << " <IPaddress> [poort] <bericht>" 
	<< endl;
    exit(1);
  } else if (argc == 4) {
    poort = atoi(argv[2]);
    bericht = argv[3];
  } else {
    poort = PROTOCOL_POORT;
    bericht = argv[2];
  }

  /* maak TCP socket */
  int sockfd = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP);
  if( sockfd < 0) {
    ExitWithMessage("socket");
  }

  /* vul server adres structure in */
  sockaddr_in servaddr = vuladresin(argv[1],poort);

  /* maak verbinding met server */
  if (connect(sockfd, (struct sockaddr *) &servaddr, sizeof(servaddr)) < 0) {
    ExitWithMessage("connect");
  }

  /* stuur string naar de server */
  char *label_hoofding = "Lengte in bytes: ";
  int lengte_bericht = strlen(bericht);
  char waarde_hoofding[7];
  sprintf(waarde_hoofding,"%d",lengte_bericht);
  char einde_hoofding = '!';
  char nieuwe_lijn = '\n';
  cout << (int) nieuwe_lijn << endl;
  int lengte_hoofding= strlen(label_hoofding) + strlen(waarde_hoofding) + 3;
  char *hoofding = new char[lengte_hoofding];
  hoofding[0] = 0;
  strcat(hoofding, label_hoofding);
  strcat(hoofding, waarde_hoofding); 
  strncat(hoofding, &einde_hoofding, 1);
  strncat(hoofding, &nieuwe_lijn, 1);
  cout << "Bericht: " << endl;
  cout << hoofding << bericht << endl;
  if(send(sockfd, hoofding, strlen(hoofding), 0) != strlen(hoofding))
    ExitWithMessage("send");
  if(send(sockfd, bericht, strlen(bericht), 0) != strlen(bericht))
    ExitWithMessage("send");
  delete hoofding;
  close(sockfd); /* sluit de verbinding */
  return 0;
}


