#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <stdlib.h>
#include <errno.h>
#include <netinet/in.h> 
#include <arpa/inet.h> // inet_addr
#include <iostream>
using namespace std;

const int MAX_GROOTTE = 256;
const int POORT = 2007;

void ExitWithMessage(char *message){
  perror(message);
  exit(1);
}

sockaddr_in vuladresin(unsigned long server, int poort) {
  /* vul server adres structure in */
  sockaddr_in servaddr;
  memset(&servaddr, 0, sizeof(servaddr));        /* maak struct leeg */
  servaddr.sin_family = AF_INET;                 /* Internet adres */
  servaddr.sin_addr.s_addr = htonl(server); /* server adres */
  servaddr.sin_port = htons(poort);          /* echo poort */
  return servaddr;
}

int lees_lengte_bericht(int connfd) {
  char buff[MAX_GROOTTE];
  int aantal_ontvangen = 0;
  int totaal_ontvangen = 0;
  aantal_ontvangen = recv(connfd,buff, 1,0);
  if (aantal_ontvangen <= 0) {
    perror("iets mis met recv()");
  }
  char ontvang_kar = buff[totaal_ontvangen];
  while ((totaal_ontvangen < MAX_GROOTTE-1) && (ontvang_kar != '!')) {
    totaal_ontvangen += aantal_ontvangen;
    aantal_ontvangen = recv(connfd,buff+totaal_ontvangen, 1,0);
    if (aantal_ontvangen <= 0) {
      perror("iets mis met recv()");
      return 0;
    }
    ontvang_kar = buff[totaal_ontvangen];
  }
  buff[totaal_ontvangen] = 0;
  char * waarde_hoofding = index(buff,':');
  waarde_hoofding += 2; // voorbij ": "
  int lengte_bericht = atoi(waarde_hoofding);
  return lengte_bericht;
}

int main(int argc, char **argv){

  /* Maak een TCP socket */
  int listenfd = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP);
  if( listenfd < 0)
    ExitWithMessage("socket");

  /* Vul server adres struct in */
  sockaddr_in servaddr = vuladresin(INADDR_ANY,POORT);
  
  /* Bind socket aan lokaal adres */
  if (bind(listenfd, (struct sockaddr *)&servaddr, sizeof(servaddr)) < 0)
    ExitWithMessage("bind");

  /* Maak de socket passief zodat hij luistert naar connectie-aanvragen */
  if(listen(listenfd, 10) < 0)
    ExitWithMessage("listen");

  /* oneindige lus */
  sockaddr_in cliaddr;
  char buff[MAX_GROOTTE];
  while(true) {
    unsigned int len = sizeof(cliaddr);
    int connfd = accept(listenfd, (sockaddr *) &cliaddr, &len);
    if(connfd < 0)
        perror("accept");
    else {
	/* er is een verbinding; handel client af */
	cout << "connectie met " << inet_ntoa(cliaddr.sin_addr) << endl;
	int lengte_bericht = lees_lengte_bericht(connfd);
	cout << "De lengte van het bericht is " << lengte_bericht << endl;
	lengte_bericht++; // nieuwe lijnteken
	int aantalOntvangen = recv(connfd,buff,lengte_bericht, 0);
	int totaal_ontvangen = aantalOntvangen;
	while(totaal_ontvangen < lengte_bericht && aantalOntvangen > 0){	
	    aantalOntvangen = recv(connfd,buff+totaal_ontvangen,lengte_bericht-totaal_ontvangen, 0);
		totaal_ontvangen += aantalOntvangen;
	}
	if (totaal_ontvangen < lengte_bericht) {
	    cout << "Er is iets mis gegaan bij het ontvangen van het bericht."
		<< endl;
	} else {
	    buff[totaal_ontvangen] = 0;
            cout << "Het ontvangen bericht is: " << endl;
            cout << buff << endl;
	}
	/* sluit de verbindig */
	close(connfd);
    }
  }
  /* onbereikbaar */
}
