/*
 * ThemaFabriek.java
 *
 * Created on 7 oktober 2007, 12:00
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package be.hogent.iii.jsf.beans;

import java.util.Collection;
import java.util.HashMap;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;

/**
 *
 * @author vongenae
 */
public class ThemaFabriek {
    private SelectItem[] themas;
    private SelectItem[] geslacht;
    private SelectItem[] maaltijden;
    private SelectItem[] landen;
    
    /** Creates a new instance of ThemaFabriek */
    public ThemaFabriek() throws ClassNotFoundException, 
            InstantiationException, IllegalAccessException {
        String klasseThemaFabriek = FacesContext.getCurrentInstance()
            .getExternalContext().getInitParameter("klasseThemaFabriek");
        IThemaFabriek implThemaFabriek = 
                (IThemaFabriek) Class.forName(klasseThemaFabriek).newInstance();
        maakSelectItemThemas(implThemaFabriek);
        maakSelectItemGeslacht();
        maakSelectItemMaaltijden(implThemaFabriek);
        maakSelectItemLanden(implThemaFabriek);
    }
    
    public SelectItem[] getThemas() {
        return themas;
    }
    
    public SelectItem[] getGeslachten() {
        return geslacht;
    }
    public SelectItem[] getLanden() {
        return landen;
    }
    public SelectItem[] getMaaltijden() {
        return maaltijden;
    }
    
    private void maakSelectItemThemas(IThemaFabriek fabriek) {
        String[] themasAlsString = fabriek.getThemas();
        themas = new SelectItem[themasAlsString.length];
        for (int i = 0; i < themas.length; i ++) {
            themas[i] = new SelectItem(themasAlsString[i]);
        }   
    }
    
    private void maakSelectItemLanden(IThemaFabriek fabriek) {
        HashMap<String,Land> landenAlsMap = fabriek.getLanden();
        landen = new SelectItem[landenAlsMap.size()];
        Collection<Land> landObjecten = landenAlsMap.values();
        Land[] landTabel = landObjecten.toArray(new Land[0]);
        for (int i = 0; i < landen.length; i ++) {
            Land land = landTabel[i];
            landen[i] = new SelectItem(land.getCode(),land.getNaam());
        }   
    }
    
    private void maakSelectItemMaaltijden(IThemaFabriek fabriek) {
        HashMap<String,String> maaltijdenMap = fabriek.getMaaltijden();
        String[] codes = (String[])maaltijdenMap.keySet().toArray(new String[0]);
        maaltijden = new SelectItem[codes.length];
        for (int i = 0; i < maaltijden.length; i++) {
            maaltijden[i] = new SelectItem(codes[i],maaltijdenMap.get(codes[i]));
        }
    }
    
    private void maakSelectItemGeslacht() {
        geslacht = new SelectItem[2];
        geslacht[0] = new SelectItem("V");
        geslacht[1] = new SelectItem("M");
    }
}
