package be.hogent.iii.jsf.beans.mem;

import java.util.ArrayList;
import java.util.List;
import javax.faces.model.SelectItem;

/**
 *
 * @author vongenae
 */
public enum Thema {
    
    SPORT("sport","Sport") , 
    ACTUALITEIT("actualiteit","Actualiteit"), 
    MUZIEK("muziek","Muziek");
    
    private String m_name;
    private String m_description;
    
    Thema (String p_name,String p_description) {
        m_name = p_name;
        m_description = p_description;
    }
    
    public String getName() {
        return m_name;
    }
    
    public String getDescription() {
        return m_description;
    }
    
    public SelectItem asSelectItem(){
        return new SelectItem(this,getName(),getDescription());
    }

    public static List<SelectItem> selectItems() {
        List<SelectItem> l_list = new ArrayList<SelectItem>();
        for (Thema l_thema : Thema.values()) {
            l_list.add(l_thema.asSelectItem());
        }
        return l_list;
    }   
}
