/*
 * ThemaFabriek.java
 *
 * Created on 6 oktober 2007, 17:55
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package be.hogent.iii.jsf.beans.mem;

import be.hogent.iii.jsf.beans.IThemaFabriek;
import be.hogent.iii.jsf.beans.Land;
import java.util.HashMap;

/**
 *
 * @author vongenae
 */
public class ThemaFabriekMem  implements IThemaFabriek {
    
    private HashMap<String, String> maaltijden;
    private String[] themas;
    private HashMap<String, Land> landen;
    
    /** Creates a new instance of ThemaFabriek */
    public ThemaFabriekMem() {
        initThemas();
        initMaaltijden();
        initLanden();        
    }

    /**
     * Holds value of property themas.
     */
    
    public String[] getThemas() {
        return themas;
    }
    
    private void initThemas() {
        //themas initialiseren
        themas = new String[3];
        themas[0] = "sport";
        themas[1] = "actualiteit";
        themas[2] = "muziek";
    }
    
    public HashMap<String, String> getMaaltijden()
    {      
        return maaltijden;
    }
    
    private void initMaaltijden() {
        // maaltijden initialiseren
        maaltijden = new HashMap<String, String>();
        maaltijden.put("ONT", "ontbijt");
        maaltijden.put("10U", "tienuurtje");
        maaltijden.put("MID", "middagmaal");
        maaltijden.put("16U", "vieruurtje");
        maaltijden.put("AVO", "avondmaal");
    }

    public HashMap<String, Land> getLanden()
    {
        return landen;
    }
    
    private void initLanden() {
        // landen initialiseren
        landen = new HashMap<String, Land>();
        String[] codes = { "BE", "NL", "FR" };
        String[] namen = { "België", "Nederland", "Frankrijk" };
        for (int i = 0; i < codes.length; i++)
        {
            Land land = new Land(codes[i], namen[i]);
            landen.put(land.getCode(), land);
        }        
    }
    
}
