#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <stdlib.h>
#include <errno.h>
#include <netinet/in.h> 
#include <arpa/inet.h> // inet_addr
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <iostream>
using namespace std;

const int POORT = 6789;
const char* MULTIADRES = "224.0.0.1";

void ExitWithMessage(string message){
  perror(message.c_str());
  exit(1);
}

sockaddr_in vuladresin(unsigned long server, int poort) {
  /* vul server adres structure in */
  sockaddr_in servaddr;
  memset(&servaddr, 0, sizeof(servaddr));        /* maak struct leeg */
  servaddr.sin_family = AF_INET;                 /* Internet adres */
  servaddr.sin_addr.s_addr = htonl(server); /* server adres */
  servaddr.sin_port = htons(poort);          /* echo poort */
  return servaddr;
}


int main(){
  sockaddr_in server_adres = vuladresin(INADDR_ANY,POORT);
  int socket_sd =  socket(PF_INET, SOCK_DGRAM, 0);
  if (socket_sd < 0)
	ExitWithMessage("socket");

  bool yes = true;
  setsockopt(socket_sd,SOL_SOCKET,SO_REUSEADDR,&yes,sizeof(yes));
  int gelukt = bind (socket_sd, (sockaddr *) &server_adres, sizeof(server_adres));
  if (gelukt < 0)
    ExitWithMessage("bind");

  ip_mreq command;
  command.imr_multiaddr.s_addr = inet_addr(MULTIADRES);
  command.imr_interface.s_addr = htonl(INADDR_ANY);
  setsockopt(socket_sd,IPPROTO_IP, IP_ADD_MEMBERSHIP,&command, sizeof(command));
  

  for(int i=0; i < 10; i++) {
    int addr_len = sizeof(server_adres);
    char bericht[256];
    int aantal = recvfrom(socket_sd, bericht, 255, 0, 
		(struct sockaddr *)&server_adres, (socklen_t*)&addr_len);
    if (aantal < 0)
		perror("recvfrom");
    else {
		bericht[aantal] = 0;
		cout << "Boodschap " << i << " " << bericht << endl;
	}
    sleep(2);
  }
  setsockopt(socket_sd,IPPROTO_IP, IP_DROP_MEMBERSHIP,&command, sizeof(command));

  close(socket_sd);
  return 0;
}
 
