#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <stdlib.h>
#include <errno.h>
#include <netinet/in.h> 
#include <arpa/inet.h> // inet_addr
#include <iostream>
#include <unistd.h>
using namespace std;

const int POORT = 6789;
const char* MULTIADRES = "224.0.0.1";
const string TEST_STRING = "testboodschap van multicast server";

void ExitWithMessage(string message){
  perror(message.c_str());
  exit(1);
}

sockaddr_in vuladresin(const char *IP_adres, int poort) {
  /* vul server adres structure in */
  sockaddr_in servaddr;
  memset(&servaddr, 0, sizeof(servaddr));    /* maak struct leeg */
  servaddr.sin_family = AF_INET;             /* Internet adres */
  if (inet_aton(IP_adres,&servaddr.sin_addr) == 0)
      ExitWithMessage("Geen IP_adres");      /* server adres */
  servaddr.sin_port = htons(poort);          /* echo poort */
  return servaddr;
}


int main(){
  sockaddr_in server_adres = vuladresin(MULTIADRES,POORT);
  int socket_sd =  socket(PF_INET, SOCK_DGRAM, 0);

  /* stuur multicast elke twee seconden */
  while(true) {
    sendto(socket_sd, TEST_STRING.c_str(), 
           TEST_STRING.length(), 0, 
           (struct sockaddr *)&server_adres, sizeof(server_adres));
    sleep(2);
  }
  /* onbereikbaar */
  return 0;
}
 
