#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <stdlib.h>
#include <errno.h>
#include <fcntl.h>
#include <netinet/in.h> 
#include <arpa/inet.h> // inet_addr
#include <iostream>
using namespace std;

const int ECHO_PORT = 7; /* poort echoserver */
const int MAX_BYTE = 10;

void exit_with_message(string message){
  perror(message.c_str());
  exit(1);
}

sockaddr_in vuladresin(char *IP_adres, int poort) {
  /* vul server adres structure in */
  sockaddr_in servaddr;
  memset(&servaddr, 0, sizeof(servaddr));    /* maak struct leeg */
  servaddr.sin_family = AF_INET;             /* Internet adres */
  if (inet_aton(IP_adres,&servaddr.sin_addr) == 0)
      exit_with_message("Geen IP_adres");      /* server adres */
  servaddr.sin_port = htons(poort);          /* echo poort */
  return servaddr;
}

void maak_non_block(int fd) {
    // fd non blocking
    int val = fcntl(fd,F_GETFL,0);
    if (val < 0)
        exit_with_message("fcntl");
    val = fcntl(fd, F_SETFL, val | O_NONBLOCK);
    if (val < 0)
        exit_with_message("fcntl");
}

void do_non_block(int sockfd) {

    // maak socket, toetsenbord en scherm nonblocking
	//cerr << fcntl(sockfd,F_GETFL,0) << endl;
    maak_non_block(sockfd);
	//cerr << fcntl(sockfd,F_GETFL,0) << endl;
    maak_non_block(STDIN_FILENO);
	//cerr << fcntl(sockfd,F_GETFL,0) << endl;
    maak_non_block(STDOUT_FILENO);
	//cerr << fcntl(sockfd,F_GETFL,0) << endl;

    // maak lees en schrijfbuffer
    char to[MAX_BYTE]; // te versturen door socket
	char fr[MAX_BYTE]; // ontvangen van socket
    char *toiptr; // einde te versturen
	char *tooptr; // begin te versturen
	char *friptr; // einde te tonen
	char *froptr; // begin te tonen
    toiptr = &to[0];
    tooptr = &to[0];
    friptr = &fr[0];
    froptr = &fr[0];

    // grootste filedescriptor
    int maxfdp1 = max(max(STDIN_FILENO,STDOUT_FILENO),sockfd)+1;

    bool einde_std_invoer = false;

    while (true) {
		// initialiseren verzameling descriptoren
        fd_set rset, wset;
        FD_ZERO(&rset);
        FD_ZERO(&wset);
        
        // plaats descriptoren in sets
        if (!einde_std_invoer && toiptr < &to[MAX_BYTE]) 
			FD_SET(STDIN_FILENO, &rset); // lees stdin
        if (friptr < &fr[MAX_BYTE])
			FD_SET(sockfd,&rset);  // lees socket
        if (tooptr != toiptr)
			FD_SET(sockfd,&wset); // schrijf naar socket
        if (froptr != friptr)
            FD_SET(STDOUT_FILENO,&wset); // schrijf naar scherm

        select(maxfdp1,&rset, &wset, NULL, NULL);

		// lees van toetsenbord?
		if (FD_ISSET(STDIN_FILENO, &rset)) {
            int n = read(STDIN_FILENO, toiptr, 
						 &to[MAX_BYTE] - toiptr); // lees van toetsenbord
			if (n < 0 && errno != EWOULDBLOCK)
				perror("leesfout op stdin");
			else if (n == 0) {
				einde_std_invoer = true;   /* klaar met stdin */
				if (tooptr == to) {
					int res = shutdown(sockfd, SHUT_WR);/* stuur FIN */
					if (res < 0)
						perror("shutdown");
				}
			} else if (n > 0) {
				toiptr += n;   /* net gelezen */
			}
		}

		// lees van socket?
		if (FD_ISSET(sockfd, &rset)) {
            int n = recv(sockfd, friptr, &fr[MAX_BYTE] - friptr,0);
			
			if (n < 0 && errno != EWOULDBLOCK)
				perror("leesfout op socket");
			else if (n == 0) {
				if (einde_std_invoer) { // testen buffer leeg???
					return; // normaal afsluiten
				} else {
					exit_with_message("server onverwacht gestopt");
				}
			} else if (n > 0){
				friptr += n;   /* net gelezen */
			}
		}

		// schrijf naar scherm?
		if(FD_ISSET(STDOUT_FILENO,&wset) && ( (friptr - froptr) > 0)){
			int n = friptr-froptr;
			int nwritten = write(STDOUT_FILENO, froptr, n);
			if (nwritten < 0 && errno != EWOULDBLOCK)
				perror("schrijffout stdout");
			else if (nwritten > 0) {
				froptr += nwritten;  /* net geschreven */
				if (froptr == friptr) {
					froptr = fr;
					friptr = fr; /* naar begin buffer */
                }
			}
		}

        // schrijf naar socket
		if ( FD_ISSET(sockfd, &wset) && ( (toiptr - tooptr) > 0)) {
			int n = toiptr-tooptr;
			int nwritten = send(sockfd, tooptr, n,0);
			if (nwritten < 0  && errno != EWOULDBLOCK)
				perror("socket schrijffout");
			else if (nwritten > 0) {
				tooptr += nwritten; /* net geschreven */
				if (tooptr == toiptr) {
					toiptr = to;
					tooptr = to; /* naar begin buffer */
					if (einde_std_invoer) {
						int result = shutdown(sockfd, SHUT_WR); /* stuur FIN */
						if (result < 0)
							perror("shutdown");
					}
				}
			}
		}
    }
}

int main (int argc, char **argv) {

    // poort en bericht inlezen
    int poort;
    if (argc < 2 || argc > 3){
        cout << "Gebruik: TCPEchoClient <IPaddress> [poort]" << endl;
        exit(1);
    } else if (argc == 3) {
        poort = atoi(argv[2]);
    } else {
        poort = ECHO_PORT;
    }

    /* maak TCP socket */
    int sockfd = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP);
    if( sockfd < 0) {
        exit_with_message("socket");
    }

    /* vul server adres structure in */
    sockaddr_in servaddr = vuladresin(argv[1],poort);

    /* maak verbinding met server */
    if (connect(sockfd, (struct sockaddr *) &servaddr, sizeof(servaddr)) < 0) {
        exit_with_message("connect");
    }

    do_non_block(sockfd);

    return 0;
}


 
