#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <stdlib.h>
#include <errno.h>
#include <fcntl.h>
#include <netinet/in.h> 
#include <arpa/inet.h> // inet_addr
#include <iostream>
using namespace std;

const int ECHO_PORT = 7; /* poort echoserver */
const int MAX_BYTE = 10;

void ExitWithMessage(string message){
  perror(message.c_str());
  exit(1);
}

sockaddr_in vuladresin(char *IP_adres, int poort) {
  /* vul server adres structure in */
  sockaddr_in servaddr;
  memset(&servaddr, 0, sizeof(servaddr));    /* maak struct leeg */
  servaddr.sin_family = AF_INET;             /* Internet adres */
  if (inet_aton(IP_adres,&servaddr.sin_addr) == 0)
      ExitWithMessage("Geen IP_adres");      /* server adres */
  servaddr.sin_port = htons(poort);          /* echo poort */
  return servaddr;
}

void doNonBlock(int sockfd) {

    // buffers
    char sendbuffer[MAX_BYTE], recvbuffer[MAX_BYTE];
    
    // kindproces starten
    int pid = fork();

    if (pid == 0) {
		// kind; lees socket
		int n = recv(sockfd, recvbuffer, MAX_BYTE, 0);
		while(n > 0) {
			recvbuffer[n] = 0;
			cout << recvbuffer;
			n = recv(sockfd, recvbuffer, MAX_BYTE, 0);
		}
		exit(0);
    } else {
	//ouder; lees toetsenbord
        int n = read(STDIN_FILENO, sendbuffer, MAX_BYTE);
		while(n > 0) {
    	    send(sockfd,sendbuffer,n,0);
            n = read(STDIN_FILENO, sendbuffer, MAX_BYTE);
        }
		int result = shutdown(sockfd, SHUT_WR);
		if (result < 0) 
			perror("shutdown");
    }
}

int main (int argc, char **argv) {

    // poort en bericht inlezen
    int poort;
    if (argc < 2 || argc > 3){
        cout << "Gebruik: TCPEchoClient <IPaddress> [poort]" << endl;
        exit(1);
    } else if (argc == 3) {
        poort = atoi(argv[2]);
    } else {
        poort = ECHO_PORT;
    }

    /* maak TCP socket */
    int sockfd = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP);
    if( sockfd < 0) {
        ExitWithMessage("socket");
    }

    /* vul server adres structure in */
    sockaddr_in servaddr = vuladresin(argv[1],poort);

    /* maak verbinding met server */
    if (connect(sockfd, (struct sockaddr *) &servaddr, sizeof(servaddr)) < 0) {
        ExitWithMessage("connect");
    }

    doNonBlock(sockfd);

    return 0;
}


 
