#include <sys/types.h>
#include <unistd.h>
#include <sys/wait.h>
#include <iostream>
using namespace std;

const int MAX = 3;

int som_vector (int tab[]) {
    int som = 0;
    for (int i = 0; i < MAX; i++)
        som += tab[i];
    return som;
}

void error_stop(string bericht) {
	perror(bericht.c_str());
	exit(1);
}

int main() {
    int getallen[MAX][MAX] = {{1,1,1},{2,2,2},{3,3,3}};
	
    // aanmaak pipe
    int pd[2];
    if (pipe(pd) == -1) {
		error_stop("pipe");
    }
	
	

    // eerste kindproces opstarten	
	int pid = fork();
	for (int i = 0; i < MAX; i++) {
        if (pid == 0) {
			cout << "kind: " << getpid() << endl;
			close(pd[0]); // kind schrijft
			int rij_som = som_vector(getallen[i]); // som berekenen
			if (write(pd[1], &rij_som, sizeof(int)) == -1) { // naar pipe schrijven
				error_stop("write");
			}
			return 0; // taak afgerond
		} else if (i < MAX - 1) {
			pid = fork(); // volgend kindproces opstarten
		}
	}
	
	// ouder leest resultaten
	if (pid != 0) { 
		cout << "ouder: " << getpid() << endl;
		close(pd[1]); // ouder leest
		int som = 0;
		// 3 getallen van pipe lezen
		for (int i = 0; i < MAX; i++) {
			int rij_som;
			if (read(pd[0],&rij_som,sizeof(int)) == -1) {
				error_stop("read");
			}
			som += rij_som;
		}
		cout << "De som is " << som << endl;
	}
	
	return 0;
}
	

