#include <sys/types.h>
#include <sys/socket.h>
#include <stdlib.h> // exit
#include <iostream> // perror 
#include <netinet/in.h> // IPPROTO_TCP 
#include <arpa/inet.h> // inet_ntoa
using namespace std;

const int MAX_LIJN = 256;
const int POORT = 2009;

void exit_with_message(char* bericht) {
     perror(bericht);
     exit(1);
}

sockaddr_in vul_adres_in(unsigned long server, int poort) {
     // vul serveradres in
     sockaddr_in server_adres;
     memset(&server_adres,0, sizeof(server_adres)); // maak struct leeg
     server_adres.sin_family = AF_INET; // internetadres
     server_adres.sin_addr.s_addr = htonl(server); // serveradres
     server_adres.sin_port = htons(poort);
     return server_adres;
}

void verwerk_klant(int connfd) {
	cout << "slaap even" << endl;
	sleep(5);
	cout << "weer wakker" << endl;
    char buffer[MAX_LIJN];
	int aantal_ontvangen = recv(connfd, buffer, MAX_LIJN - 1, 0);
	while (aantal_ontvangen > 0) {
		buffer[aantal_ontvangen] = 0;
		int aantal_verzonden = send(connfd, buffer, strlen(buffer), 0);
		if (aantal_verzonden < 0)
			perror("send");
		aantal_ontvangen = recv(connfd, buffer, MAX_LIJN - 1, 0);
	}
}

void afsluiten_kindprocessen() {
	int status;
	int pid_gestopt = waitpid(0,&status,WNOHANG|WUNTRACED);
	while (pid_gestopt > 0) {
		cout << "Proces " << pid_gestopt << " is afgesloten." << endl;
		if (WIFEXITED(status)) {
			cout << "Normaal afgesloten. Status: " 
			<< WEXITSTATUS(status) << endl;
		} else {
			cout << "Afgesloten door een signaal: " 
			<< WTERMSIG(status) << endl;
		}
		pid_gestopt = waitpid(0,&status,WNOHANG|WUNTRACED);		
	}	
}

int main() {
     // maak TCP-socket
     int listenfd = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP);
     if (listenfd < 0)
         exit_with_message("socket");

     // vul serveradres in struct
     sockaddr_in server_adres = vul_adres_in(INADDR_ANY, POORT);

     // bind socket aan lokaal adres
     if (bind(listenfd, (struct sockaddr *) &server_adres, sizeof(server_adres)) < 0)
         exit_with_message("bind");

     // maak socket passief --> luisteren naar aanvragen
     if (listen(listenfd, 10) < 0)
         exit_with_message("listen");

    // oneindige lus  
	bool luisteren = true;
    while (luisteren) {
		sockaddr_in client_adres;  
         unsigned int lengte = sizeof(client_adres);
         int connfd = accept(listenfd, (sockaddr *) &client_adres, &lengte);
         if (connfd < 0)
             perror("accept");
         else { 			 
			 int pid = fork();
			 if (pid == 0) { // kind				 
				 close(listenfd);
				 cout << "verbinding met " << inet_ntoa(client_adres.sin_addr) << endl;// verbinding met client
				 verwerk_klant(connfd);
				 close(connfd);
				 exit(0);
			 } else {// ouder
				 close (connfd); // teller verminderen
				 // zijn kindprocessen gestopt?
				 afsluiten_kindprocessen();
			 }
         }
     }
     // onbereikbaar 
}
