using System;
using System.Collections.Generic;
using System.Text;

namespace VbRemoteObject
{
    public class RemoteTijd : MarshalByRefObject
    {
        private DateTime m_startTime;

        public RemoteTijd()
        {
            Console.WriteLine("RemoteTijd created without constructor.");
            Console.WriteLine("Instance hash is " + GetHashCode().ToString());
            m_startTime = DateTime.Now;
        }

        ~RemoteTijd()
        {
            Console.Write("I'm being collected after ");
            Console.Write((new TimeSpan(DateTime.Now.Ticks - m_startTime.Ticks)).ToString());
            Console.WriteLine(" seconds.");
        }

        public DateTime GetServerTime()
        {
            Console.WriteLine("Time requested by a client.");
            return DateTime.Now;
        }

        public int InstanceHash
        {
            get { return GetHashCode(); }
        }
    }
}
