#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <stdlib.h>
#include <errno.h>
#include <netinet/in.h> 
#include <arpa/inet.h> // inet_addr
#include <iostream>
using namespace std;

const int RCVBUFSIZE = 32; /* grootte receive buffer */
const int ECHO_PORT = 7; /* poort echoserver */

void ExitWithMessage(char *message){
  perror(message);
  exit(1);
}

sockaddr_in vuladresin(char *IP_adres, int poort) {
  /* vul server adres structure in */
  sockaddr_in servaddr;
  memset(&servaddr, 0, sizeof(servaddr));    /* maak struct leeg */
  servaddr.sin_family = AF_INET;             /* Internet adres */
  if (inet_aton(IP_adres,&servaddr.sin_addr) == 0)
      ExitWithMessage("Geen IP_adres");      /* server adres */
  servaddr.sin_port = htons(poort);          /* echo poort */
  return servaddr;
}

int main(int argc, char **argv){

  // poort en bericht inlezen
  int poort;
  char *bericht;
  if (argc < 3 || argc > 4){
    cout << "Gebruik: TCPEchoClient <IPaddress> [poort] <bericht>" << endl;
    exit(1);
  } else if (argc == 4) {
    poort = atoi(argv[2]);
    bericht = argv[3];
  } else {
    poort = ECHO_PORT;
    bericht = argv[2];
  }

  /* maak TCP socket */
  int sockfd = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP);
  if( sockfd < 0) {
    ExitWithMessage("socket");
  }

  /* vul server adres structure in */
  sockaddr_in servaddr = vuladresin(argv[1],poort);

  /* maak verbinding met server */
  if (connect(sockfd, (struct sockaddr *) &servaddr, sizeof(servaddr)) < 0) {
    ExitWithMessage("connect");
  }

  /* stuur string naar de server */
  int echoStringLen = strlen(bericht);
  if( send(sockfd, bericht, echoStringLen, 0) != echoStringLen )
    ExitWithMessage("send");

  /* lees antwoord van de server */
  char buffer[RCVBUFSIZE];
  int totalBytesRcvd = 0;
  cout << "Ontvangen: " << endl;
  while (totalBytesRcvd < echoStringLen) {
    int bytesRcvd = recv(sockfd, buffer, RCVBUFSIZE-1, 0);
    if (bytesRcvd <= 0){
      ExitWithMessage("recv");
    }
    totalBytesRcvd += bytesRcvd;
    buffer[bytesRcvd] = '\0'; /* string eindigt met 0 */
    cout << buffer;
  }
  cout << endl; /* final endline */
  close(sockfd); /* sluit de verbinding */
  return 0;
}


