/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher;

import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ClassLoaderUtil;
import com.opensymphony.xwork2.util.profiling.UtilTimerStack;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.RequestUtils;
import org.apache.struts2.StrutsStatics;
import org.apache.struts2.dispatcher.ActionContextCleanUp;
import org.apache.struts2.dispatcher.Dispatcher;
import org.apache.struts2.dispatcher.mapper.ActionMapper;
import org.apache.struts2.dispatcher.mapper.ActionMapping;

public class FilterDispatcher
implements StrutsStatics,
Filter {
    private static final Log LOG = LogFactory.getLog(FilterDispatcher.class);
    private String[] pathPrefixes;
    private final Calendar lastModifiedCal = Calendar.getInstance();
    private static boolean serveStatic;
    private static boolean serveStaticBrowserCache;
    private static String encoding;
    private static ActionMapper actionMapper;
    private FilterConfig filterConfig;
    protected Dispatcher dispatcher;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        this.dispatcher = this.createDispatcher(filterConfig);
        this.dispatcher.init();
        String param = filterConfig.getInitParameter("packages");
        String packages = "org.apache.struts2.static template org.apache.struts2.interceptor.debugging";
        if (param != null) {
            packages = param + " " + packages;
        }
        this.pathPrefixes = this.parse(packages);
    }

    public void destroy() {
        if (this.dispatcher == null) {
            LOG.warn((Object)"something is seriously wrong, Dispatcher is not initialized (null) ");
        } else {
            this.dispatcher.cleanup();
        }
    }

    protected Dispatcher createDispatcher(FilterConfig filterConfig) {
        HashMap<String, String> params = new HashMap<String, String>();
        Enumeration e = filterConfig.getInitParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = filterConfig.getInitParameter(name);
            params.put(name, value);
        }
        return new Dispatcher(filterConfig.getServletContext(), params);
    }

    @Inject(value="struts.serve.static")
    public static void setServeStaticContent(String val) {
        serveStatic = "true".equals(val);
    }

    @Inject(value="struts.serve.static.browserCache")
    public static void setServeStaticBrowserCache(String val) {
        serveStaticBrowserCache = "true".equals(val);
    }

    @Inject(value="struts.i18n.encoding")
    public static void setEncoding(String val) {
        encoding = val;
    }

    @Inject
    public static void setActionMapper(ActionMapper mapper) {
        actionMapper = mapper;
    }

    protected ServletContext getServletContext() {
        return this.filterConfig.getServletContext();
    }

    protected FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    protected HttpServletRequest prepareDispatcherAndWrapRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        Dispatcher du = Dispatcher.getInstance();
        if (du == null) {
            Dispatcher.setInstance(this.dispatcher);
            this.dispatcher.prepare(request, response);
        } else {
            this.dispatcher = du;
        }
        try {
            request = this.dispatcher.wrapRequest(request, this.getServletContext());
        }
        catch (IOException e) {
            String message = "Could not wrap servlet request with MultipartRequestWrapper!";
            LOG.error((Object)message, (Throwable)e);
            throw new ServletException(message, (Throwable)e);
        }
        return request;
    }

    protected String[] parse(String packages) {
        if (packages == null) {
            return null;
        }
        ArrayList<String> pathPrefixes = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(packages, ", \n\t");
        while (st.hasMoreTokens()) {
            String pathPrefix = st.nextToken().replace('.', '/');
            if (!pathPrefix.endsWith("/")) {
                pathPrefix = pathPrefix + "/";
            }
            pathPrefixes.add(pathPrefix);
        }
        return pathPrefixes.toArray(new String[pathPrefixes.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        ServletContext servletContext = this.getServletContext();
        String timerKey = "FilterDispatcher_doFilter: ";
        try {
            ActionMapping mapping;
            UtilTimerStack.push((String)timerKey);
            request = this.prepareDispatcherAndWrapRequest(request, response);
            try {
                mapping = actionMapper.getMapping(request, this.dispatcher.getConfigurationManager());
            }
            catch (Exception ex) {
                LOG.error((Object)"error getting ActionMapping", (Throwable)ex);
                this.dispatcher.sendError(request, response, servletContext, 500, ex);
                try {
                    ActionContextCleanUp.cleanUp(req);
                }
                finally {
                    UtilTimerStack.pop((String)timerKey);
                }
                return;
            }
            if (mapping == null) {
                String resourcePath = RequestUtils.getServletPath(request);
                if ("".equals(resourcePath) && null != request.getPathInfo()) {
                    resourcePath = request.getPathInfo();
                }
                if (serveStatic && resourcePath.startsWith("/struts")) {
                    String name = resourcePath.substring("/struts".length());
                    this.findStaticResource(name, request, response);
                } else {
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                }
                return;
            }
            this.dispatcher.serviceAction(request, response, servletContext, mapping);
        }
        finally {
            try {
                ActionContextCleanUp.cleanUp(req);
            }
            finally {
                UtilTimerStack.pop((String)timerKey);
            }
        }
    }

    public void findStaticResource(String path, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String name = this.cleanupPath(path);
        for (String pathPrefix : this.pathPrefixes) {
            InputStream is;
            block3: {
                URL resourceUrl = this.findResource(this.buildPath(name, pathPrefix));
                if (resourceUrl == null) continue;
                is = null;
                try {
                    String pathEnding = this.buildPath(name, pathPrefix);
                    if (!resourceUrl.getFile().endsWith(pathEnding)) break block3;
                    is = resourceUrl.openStream();
                }
                catch (Exception ex) {
                    continue;
                }
            }
            if (is == null) continue;
            this.process(is, path, request, response);
            return;
        }
        response.sendError(404);
    }

    protected URL findResource(String path) throws IOException {
        return ClassLoaderUtil.getResource((String)path, this.getClass());
    }

    protected String buildPath(String name, String packagePrefix) throws UnsupportedEncodingException {
        String resourcePath = packagePrefix.endsWith("/") && name.startsWith("/") ? packagePrefix + name.substring(1) : packagePrefix + name;
        return URLDecoder.decode(resourcePath, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(InputStream is, String path, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (is != null) {
            Calendar cal = Calendar.getInstance();
            long ifModifiedSince = 0L;
            try {
                ifModifiedSince = request.getDateHeader("If-Modified-Since");
            }
            catch (Exception e) {
                LOG.warn((Object)("Invalid If-Modified-Since header value: '" + request.getHeader("If-Modified-Since") + "', ignoring"));
            }
            long lastModifiedMillis = this.lastModifiedCal.getTimeInMillis();
            long now = cal.getTimeInMillis();
            cal.add(5, 1);
            long expires = cal.getTimeInMillis();
            if (ifModifiedSince > 0L && ifModifiedSince <= lastModifiedMillis) {
                response.setDateHeader("Expires", expires);
                response.setStatus(304);
                is.close();
                return;
            }
            String contentType = this.getContentType(path);
            if (contentType != null) {
                response.setContentType(contentType);
            }
            if (serveStaticBrowserCache) {
                response.setDateHeader("Date", now);
                response.setDateHeader("Expires", expires);
                response.setDateHeader("Retry-After", expires);
                response.setHeader("Cache-Control", "public");
                response.setDateHeader("Last-Modified", lastModifiedMillis);
            } else {
                response.setHeader("Cache-Control", "no-cache");
                response.setHeader("Pragma", "no-cache");
                response.setHeader("Expires", "-1");
            }
            try {
                this.copy(is, (OutputStream)response.getOutputStream());
            }
            finally {
                is.close();
            }
        }
    }

    protected String getContentType(String name) {
        if (name.endsWith(".js")) {
            return "text/javascript";
        }
        if (name.endsWith(".css")) {
            return "text/css";
        }
        if (name.endsWith(".html")) {
            return "text/html";
        }
        if (name.endsWith(".txt")) {
            return "text/plain";
        }
        if (name.endsWith(".gif")) {
            return "image/gif";
        }
        if (name.endsWith(".jpg") || name.endsWith(".jpeg")) {
            return "image/jpeg";
        }
        if (name.endsWith(".png")) {
            return "image/png";
        }
        return null;
    }

    protected void copy(InputStream input, OutputStream output) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        output.flush();
    }

    protected InputStream findInputStream(String name, String packagePrefix) throws IOException {
        String resourcePath = packagePrefix.endsWith("/") && name.startsWith("/") ? packagePrefix + name.substring(1) : packagePrefix + name;
        resourcePath = URLDecoder.decode(resourcePath, encoding);
        return ClassLoaderUtil.getResourceAsStream((String)resourcePath, this.getClass());
    }

    protected String cleanupPath(String path) {
        return path.substring(7);
    }
}

