/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.freemarker;

import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.FileManager;
import com.opensymphony.xwork2.util.ValueStack;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.cache.WebappTemplateLoader;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.jsp.TaglibFactory;
import freemarker.ext.servlet.HttpRequestHashModel;
import freemarker.ext.servlet.HttpRequestParametersHashModel;
import freemarker.ext.servlet.HttpSessionHashModel;
import freemarker.ext.servlet.ServletContextHashModel;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.GenericServlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.views.JspSupportServlet;
import org.apache.struts2.views.TagLibrary;
import org.apache.struts2.views.freemarker.ScopesHashModel;
import org.apache.struts2.views.freemarker.StrutsBeanWrapper;
import org.apache.struts2.views.freemarker.StrutsClassTemplateLoader;
import org.apache.struts2.views.util.ContextUtil;

public class FreemarkerManager {
    private static final Log LOG = LogFactory.getLog(FreemarkerManager.class);
    public static final String CONFIG_SERVLET_CONTEXT_KEY = "freemarker.Configuration";
    public static final String KEY_EXCEPTION = "exception";
    private static final String ATTR_APPLICATION_MODEL = ".freemarker.Application";
    private static final String ATTR_JSP_TAGLIBS_MODEL = ".freemarker.JspTaglibs";
    private static final String ATTR_REQUEST_MODEL = ".freemarker.Request";
    private static final String ATTR_REQUEST_PARAMETERS_MODEL = ".freemarker.RequestParameters";
    public static final String KEY_APPLICATION = "Application";
    public static final String KEY_REQUEST_MODEL = "Request";
    public static final String KEY_SESSION_MODEL = "Session";
    public static final String KEY_JSP_TAGLIBS = "JspTaglibs";
    public static final String KEY_REQUEST_PARAMETER_MODEL = "Parameters";
    private String encoding;
    private boolean altMapWrapper;
    private Map<String, TagLibrary> tagLibraries;

    @Inject(value="struts.i18n.encoding")
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Inject(value="struts.freemarker.wrapper.altMap")
    public void setWrapperAltMap(String val) {
        this.altMapWrapper = "true".equals(val);
    }

    @Inject
    public void setContainer(Container container) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Set prefixes = container.getInstanceNames(TagLibrary.class);
        for (String prefix : prefixes) {
            map.put(prefix, container.getInstance(TagLibrary.class, prefix));
        }
        this.tagLibraries = Collections.unmodifiableMap(map);
    }

    public final synchronized Configuration getConfiguration(ServletContext servletContext) throws TemplateException {
        Configuration config = (Configuration)servletContext.getAttribute(CONFIG_SERVLET_CONTEXT_KEY);
        if (config == null) {
            config = this.createConfiguration(servletContext);
            servletContext.setAttribute(CONFIG_SERVLET_CONTEXT_KEY, (Object)config);
        }
        config.setWhitespaceStripping(true);
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ScopesHashModel buildScopesHashModel(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, ObjectWrapper wrapper, ValueStack stack) {
        HttpRequestHashModel requestModel;
        ScopesHashModel model = new ScopesHashModel(wrapper, servletContext, request, stack);
        ServletContext servletContext2 = servletContext;
        synchronized (servletContext2) {
            JspSupportServlet servlet;
            ServletContextHashModel servletContextModel = (ServletContextHashModel)servletContext.getAttribute(ATTR_APPLICATION_MODEL);
            if (servletContextModel == null && (servlet = JspSupportServlet.jspSupportServlet) != null) {
                servletContextModel = new ServletContextHashModel((GenericServlet)servlet, wrapper);
                servletContext.setAttribute(ATTR_APPLICATION_MODEL, (Object)servletContextModel);
                TaglibFactory taglibs = new TaglibFactory(servletContext);
                servletContext.setAttribute(ATTR_JSP_TAGLIBS_MODEL, (Object)taglibs);
            }
            model.put(KEY_APPLICATION, servletContextModel);
            model.put(KEY_JSP_TAGLIBS, (TemplateModel)servletContext.getAttribute(ATTR_JSP_TAGLIBS_MODEL));
        }
        HttpSession session = request.getSession(false);
        if (session != null) {
            model.put(KEY_SESSION_MODEL, new HttpSessionHashModel(session, wrapper));
        }
        if ((requestModel = (HttpRequestHashModel)request.getAttribute(ATTR_REQUEST_MODEL)) == null || requestModel.getRequest() != request) {
            requestModel = new HttpRequestHashModel(request, response, wrapper);
            request.setAttribute(ATTR_REQUEST_MODEL, (Object)requestModel);
        }
        model.put(KEY_REQUEST_MODEL, requestModel);
        HttpRequestParametersHashModel reqParametersModel = (HttpRequestParametersHashModel)request.getAttribute(ATTR_REQUEST_PARAMETERS_MODEL);
        if (reqParametersModel == null || requestModel.getRequest() != request) {
            reqParametersModel = new HttpRequestParametersHashModel(request);
            request.setAttribute(ATTR_REQUEST_PARAMETERS_MODEL, (Object)reqParametersModel);
        }
        model.put(KEY_REQUEST_PARAMETER_MODEL, reqParametersModel);
        return model;
    }

    protected void populateContext(ScopesHashModel model, ValueStack stack, Object action, HttpServletRequest request, HttpServletResponse response) {
        Map standard = ContextUtil.getStandardContext(stack, request, response);
        model.putAll(standard);
        Throwable exception = (Throwable)request.getAttribute("javax.servlet.error.exception");
        if (exception == null) {
            exception = (Throwable)request.getAttribute("javax.servlet.error.JspException");
        }
        if (exception != null) {
            model.put(KEY_EXCEPTION, exception);
        }
    }

    protected BeansWrapper getObjectWrapper() {
        return new StrutsBeanWrapper(this.altMapWrapper);
    }

    protected TemplateLoader getTemplateLoader(ServletContext servletContext) {
        FileTemplateLoader templatePathLoader = null;
        String templatePath = servletContext.getInitParameter("TemplatePath");
        if (templatePath == null) {
            templatePath = servletContext.getInitParameter("templatePath");
        }
        if (templatePath != null) {
            try {
                templatePathLoader = new FileTemplateLoader(new File(templatePath));
            }
            catch (IOException e) {
                LOG.error((Object)("Invalid template path specified: " + e.getMessage()), (Throwable)e);
            }
        }
        return templatePathLoader != null ? new MultiTemplateLoader(new TemplateLoader[]{templatePathLoader, new WebappTemplateLoader(servletContext), new StrutsClassTemplateLoader()}) : new MultiTemplateLoader(new TemplateLoader[]{new WebappTemplateLoader(servletContext), new StrutsClassTemplateLoader()});
    }

    protected Configuration createConfiguration(ServletContext servletContext) throws TemplateException {
        Configuration configuration = new Configuration();
        configuration.setTemplateLoader(this.getTemplateLoader(servletContext));
        configuration.setTemplateExceptionHandler(TemplateExceptionHandler.HTML_DEBUG_HANDLER);
        configuration.setObjectWrapper((ObjectWrapper)this.getObjectWrapper());
        if (this.encoding != null) {
            configuration.setDefaultEncoding(this.encoding);
        }
        this.loadSettings(servletContext, configuration);
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadSettings(ServletContext servletContext, Configuration configuration) {
        InputStream in = null;
        try {
            in = FileManager.loadFile((String)"freemarker.properties", FreemarkerManager.class);
            if (in != null) {
                Properties p = new Properties();
                p.load(in);
                configuration.setSettings(p);
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Error while loading freemarker settings from /freemarker.properties", (Throwable)e);
        }
        catch (TemplateException e) {
            LOG.error((Object)"Error while loading freemarker settings from /freemarker.properties", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException io) {
                    LOG.warn((Object)"Unable to close input stream", (Throwable)io);
                }
            }
        }
    }

    public SimpleHash buildTemplateModel(ValueStack stack, Object action, ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, ObjectWrapper wrapper) {
        ScopesHashModel model = this.buildScopesHashModel(servletContext, request, response, wrapper, stack);
        this.populateContext(model, stack, action, request, response);
        for (String prefix : this.tagLibraries.keySet()) {
            model.put(prefix, this.tagLibraries.get(prefix).getFreemarkerModels(stack, request, response));
        }
        return model;
    }
}

