#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <stdlib.h>
#include <errno.h>
#include <netinet/in.h> 
#include <arpa/inet.h>
#include <pthread.h>
#include <iostream>
using namespace std;


const int MAXLINE = 256;
const int ECHO_PORT = 2007;

void * verwerk_client(void *arg){
	cout << "in slaap" << endl;
	sleep(3);
	cout << "wakker" << endl;
	char buffer[MAXLINE];
	int *p_connfd = (int *) arg;
	int aantal_bytes, fd;
	fd = *p_connfd;
	delete p_connfd;
	aantal_bytes = read(fd, buffer, MAXLINE);
	while( aantal_bytes > 0){
		write(fd, buffer, aantal_bytes);
		aantal_bytes = read(fd, buffer, MAXLINE);
	}
	close(fd);
	return (NULL);
}

void ExitWithMessage(string message){
	perror(message.c_str());
	exit(1);
}


sockaddr_in vuladresin(unsigned long server, int poort) {
	/* vul server adres structure in */
	sockaddr_in servaddr;
	memset(&servaddr, 0, sizeof(servaddr));        /* maak struct leeg */
	servaddr.sin_family = AF_INET;                 /* Internet adres */
	servaddr.sin_addr.s_addr = htonl(server); /* server adres */
	servaddr.sin_port = htons(poort);          /* echo poort */
	return servaddr;
}

int maak_luister_socket(int poort) {

	/* Maak een TCP socket */
	int listenfd = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP);
	if( listenfd < 0)
		ExitWithMessage("socket");

	/* Vul server adres struct in */
	sockaddr_in servaddr = vuladresin(INADDR_ANY,poort);
  
	/* Bind socket aan lokaal adres */
	if (bind(listenfd, (struct sockaddr *)&servaddr, sizeof(servaddr)) < 0)
		ExitWithMessage("bind");

	/* Maak de socket passief zodat hij luistert naar connectie-aanvragen */
	if(listen(listenfd, 10) < 0)
		ExitWithMessage("listen");

	return listenfd;
}



int main(){
	int listenfd = maak_luister_socket(ECHO_PORT);
	while(true){
		socklen_t len;
		sockaddr_in cliaddr;
		len = sizeof(cliaddr);
		//int connfd = accept(listenfd, (sockaddr *) &cliaddr, &len);
		int *p_connfd = new int;
		*p_connfd = accept(listenfd, (sockaddr *) &cliaddr, &len);
		//if (connfd < 0) {
		if (*p_connfd < 0) {
			perror("accept");
		} else {
			pthread_t id;
			//pthread_create(&id, NULL, &verwerk_client, (void *) &connfd);
			pthread_create(&id, NULL, &verwerk_client, (void *) p_connfd);
		}
	}
	return 0;
}

