#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <stdlib.h>
#include <errno.h>
#include <netinet/in.h> 
#include <arpa/inet.h> // inet_addr
#include <stdio.h>
#include <string.h> 
#include <unistd.h>
#include <iostream>
using namespace std;

const int SERV_PORT = 4567;
const int MAXLINE = 256;

void ExitWithMessage(string message){
  perror(message.c_str());
  exit(1);
}

sockaddr_in vuladresin(char *IP_adres, int poort) {
  /* vul server adres structure in */
  sockaddr_in servaddr;
  memset(&servaddr, 0, sizeof(servaddr));    /* maak struct leeg */
  servaddr.sin_family = AF_INET;             /* Internet adres */
  if (inet_aton(IP_adres,&servaddr.sin_addr) == 0)
      ExitWithMessage("Geen IP_adres");      /* server adres */
  servaddr.sin_port = htons(poort);          /* echo poort */
  return servaddr;
}


void doe_echo(int fd, int sockfd, const sockaddr *pservaddr, socklen_t servlen){
  
  char buffer[MAXLINE+1];

  int aant = read(fd, buffer, MAXLINE);
  while (aant > 0) {
    sendto(sockfd, buffer, aant, 0, pservaddr, servlen);
    
    int n = recvfrom(sockfd, buffer, MAXLINE,0,0,0);
    buffer[n] = 0; /* null terminate */
    cout << buffer;
    
    aant = read(fd, buffer, MAXLINE);
  }
}

int main(int argc, char **argv){
  int sockfd;
  sockaddr_in servaddr = vuladresin(argv[1],SERV_PORT);
  sockfd = socket(AF_INET, SOCK_DGRAM, 0);
  if (sockfd < 0)
    ExitWithMessage("socket");
  doe_echo(STDIN_FILENO, sockfd, (sockaddr *) &servaddr, sizeof(servaddr));
}



