#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <stdlib.h>
#include <errno.h>
#include <netinet/in.h> 
#include <arpa/inet.h> // inet_addr
#include <iostream>
using namespace std;

const int SERV_PORT = 4567;
const int MAXLINE = 256;

void ExitWithMessage(string message){
  perror(message.c_str());
  exit(1);
}

sockaddr_in vuladresin(unsigned long server, int poort) {
  /* vul server adres structure in */
  sockaddr_in servaddr;
  memset(&servaddr, 0, sizeof(servaddr));        /* maak struct leeg */
  servaddr.sin_family = AF_INET;                 /* Internet adres */
  servaddr.sin_addr.s_addr = htonl(server); /* server adres */
  servaddr.sin_port = htons(poort);          /* echo poort */
  return servaddr;
}

int main(int argc, char **argv){
  char mesg[MAXLINE];

  int sockfd = socket(PF_INET, SOCK_DGRAM, IPPROTO_UDP);
  if (sockfd < 0)
    ExitWithMessage("socket");
  sockaddr_in servaddr = vuladresin(INADDR_ANY,SERV_PORT);

  int gelukt = bind(sockfd, (sockaddr *) &servaddr, sizeof(servaddr));
  if (gelukt < 0)
    ExitWithMessage("bind");

  while (true) {
    sockaddr cliaddr;
    int len = sizeof(cliaddr);
    int n = 
	  recvfrom(sockfd, mesg, MAXLINE, 0, &cliaddr, 
			   (socklen_t *)&len);
    if (n < 0)
		perror("recvfrom");
    int result = sendto(sockfd, mesg, n, 0, &cliaddr, len);
    if (result < 0)
		perror("sendto");
  }
}
 
